<?php
include ('connection.php');
include ('sqldbquery.php');
include('functions.php');
ini_set('max_execution_time', 200000);
//$appcon=$GLOBALS['con'];


$CD = date('Y-m-d');

if(date('d') == '1'){
	$startdate= date('Y-m-d', strtotime('first day of previous month'));
	$enddate = date('Y-m-d', strtotime('last day of previous month'));   
}
else
{
	$startdate= date("Y-m-01", strtotime($CD));
	$enddate = date('Y-m-d');	
}

$brand_startdate= date("Y-m-01", strtotime($startdate));
$temp = date("Y-m-d",strtotime($brand_startdate." +1 months"));
$brand_enddate = date("Y-m-d",strtotime($temp." -1 Day"));


$pm_status = get_process_status($con);

if($pm_status == 0)
{
	mysqli_query($con, "UPDATE `processing_status` SET `process_margin_status` = '1', `start_at`= NOW()  WHERE id = '3' ");

	calculate_gross_margin_summary($con, $brand_startdate, $brand_enddate);

	mysqli_query($con, "UPDATE processing_status SET `process_margin_status` = '0' , `end_at` = NOW() WHERE id= '3' "); 
	echo "Done Processing" ;

}
else
{
	echo "Margin is already Calculating by some Other User. Please Wait ! ";
} 


function get_process_status($con){
	$pq= mysqli_query($con, "SELECT process_margin_status FROM processing_status WHERE id = '3' ");
	while ($pq_result= mysqli_fetch_array($pq))
	{
		$pm_status= $pq_result["process_margin_status"];
	}
	return $pm_status;
}


function calculate_gross_margin_summary($con, $fromdate, $todate)
{

	$pdata = "DELETE FROM `gross_margin_summary` WHERE fromdate = '$fromdate' AND  todate = '$todate'  ";
	$pdataExecute = mysqli_query($con, $pdata); 

	$que ="SELECT 
	store_id, SUM(soldprice) as total_sale, 
	SUM(CASE WHEN (ig_id = 2) THEN margin ELSE 0 END) AS margin_acc, 
	SUM(CASE WHEN (ig_id = 4) THEN margin ELSE 0 END) AS margin_pt 
	FROM `gross_margin`
	WHERE 
	transdate BETWEEN date('$fromdate') AND date('$todate')  AND 
	store_id !='ECOM04'  
	GROUP by store_id";

	$result2= mysqli_query($con, $que);

          while ($row = mysqli_fetch_array($result2)) 
          {     

          $total_sale= $row['total_sale'];
          $margin_acc= $row['margin_acc'];
          $margin_pt= $row['margin_pt'];
          $store_id= $row['store_id'];
          $targets=get_targets($con, $store_id, $fromdate , $todate);

          $ET = $targets["ET"];
          $NT = $targets["NT"];
          $CT = $targets["CT"];
         
          $workingDays= 26;
          $ET_pday =round(($ET / $workingDays), 2);
          $CT_pday = round(($CT / $workingDays),2);
          $NT_pday =round(($NT / $workingDays), 2);

          $margin_return=get_margin($con, $store_id, $fromdate , $todate);
          $margin_1= $margin_return["b_margin"];
          $margin= round($margin_1, 0);
          $margin_ho= $margin_return["margin_ho"];

          $margin_ach_ET= ($margin / $ET) * 100 ;
          $margin_ach_NT= ($margin / $NT) * 100 ;
          $margin_ach_CT= ($margin / $CT) * 100 ;
          
          $units = get_sale_units($con, $fromdate, $todate, $store_id);
          $store_data= get_shop_name($con, $store_id);

          insert_margin_summary($con,$store_id,$store_data["SN"],$ET,$ET_pday,$NT,$NT_pday,$CT,$CT_pday,$workingDays,$total_sale,$units,$margin_ho,$margin,$margin_acc,$margin_pt,$margin_ach_ET,$margin_ach_NT,$margin_ach_CT,$store_data["reg_id"],$store_data["subreg_id"],$store_data["rm_id"],$store_data["multi_regid"],$fromdate,$todate);
      }

      $queSort ="SELECT * 
                    FROM `gross_margin_summary`
                    WHERE fromdate = date('$fromdate') AND todate = date('$todate')
                    ORDER BY cTAchieved DESC";

      $resultSort= mysqli_query($con, $queSort);

      $rank = 1;
      while ($row = mysqli_fetch_array($resultSort)) 
      { 
        $storeID= $row['storeID'];
        $updateRankQuery = "UPDATE `gross_margin_summary` SET `rank` = '$rank' WHERE storeID = '$storeID'";
        mysqli_query($con, $updateRankQuery);
        $rank++;
      }

  }

  function insert_margin_summary($con,$store_id,$store_Name,$ET,$ET_pday,$NT,$NT_pday,$CT,$CT_pday,$workingDays,$totalSale,$units,$margin_ho,$margin,$margin_acc,$margin_pt,$margin_ach_ET,$margin_ach_NT,$margin_ach_CT,$reg_id,$subreg_id,$rm_id,$multi_regid,$fromdate,$todate)
  {
  	
  	$insertQuery = "INSERT INTO  `gross_margin_summary` 
  	(`storeID`,
  	`storeName`,
  	`expense`,
  	`ePD`,
  	`normalTarget`,
  	`ntPD`,
  	`challengeTarget`,
  	`ctPD`,
  	`workingDays`,
  	`totalSale`,
  	`units`,
  	`marginHO`,
  	`marginBranch`,
  	`marginBranchA`,
  	`marginBranchPT`,
  	`eTAchieved`,
  	`nTAchieved`,
  	`cTAchieved`,
  	`regID`,
  	`subRegID`,
  	`rmID`,
  	`multiRegID`,
  	`fromdate`,
  	`todate`,
  	`createdAt`) 
  	VALUES (
  	'$store_id',
  	'$store_Name',
  	'$ET',
  	'$ET_pday',
  	'$NT',
  	'$NT_pday',
  	'$CT',
  	'$CT_pday',
  	'$workingDays',
  	'$totalSale',
  	'$units',
  	'$margin_ho',
  	'$margin',
  	'$margin_acc',
  	'$margin_pt',
  	'$margin_ach_ET',
  	'$margin_ach_NT',
  	'$margin_ach_CT',
  	'$reg_id',
  	'$subreg_id',
  	'$rm_id',
  	'$multi_regid',
  	'$fromdate',
  	'$todate',
  	NOW() )";

  	mysqli_query($con, $insertQuery);

  }





?> 

